(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     40069,        874]
NotebookOptionsPosition[     39735,        857]
NotebookOutlinePosition[     40089,        873]
CellTagsIndexPosition[     40046,        870]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "NMR", " ", "Spectrum", " ", "without", " ", "Noise", " ", "component"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Note", ":", " ", "\[IndentingNewLine]", "\t  ", 
     RowBox[{
     "This", " ", "test", " ", "is", " ", "somehow", " ", "chanllenging", " ",
       "for", " ", "the", " ", 
      RowBox[{"computer", ".", "\[IndentingNewLine]", "\t", "Please"}], " ", 
      "be", " ", "patient", " ", "when", " ", "you", " ", "change", " ", 
      "the", " ", "paratmeter", " ", "in", " ", "the", " ", "control", " ", 
      RowBox[{"panel", ".", "\[IndentingNewLine]", "\t", "Especially"}], " ", 
      "when", " ", "you", " ", "set", " ", "a", " ", "high", " ", "value", 
      " ", "for", " ", "transients"}]}], ",", " ", 
    RowBox[{
    "the", " ", "program", " ", "will", " ", "last", " ", "long", " ", "with",
      " ", "every", " ", "changes", " ", "of", " ", "other", " ", 
     "parameters"}]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "\"\<`Global*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{"t0", "/", "n"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Free Induction Decay (Real Part)\>\"", ",", 
               "\"\<Label\>\"", ",", "15", ",", "Red", ",", "Bold"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Re", "[", 
                 RowBox[{"m", "*", 
                  RowBox[{"Cos", "[", 
                   RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "t"}], "+", 
                    "\[CurlyPhi]"}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"T", "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", "lb"}], "*", "T"}], "]"}], "*", "A", "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", "w0", "*", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "/", "T2"}], "]"}], 
                  "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                    "]"}]}], "]"}], "+", 
                RowBox[{"Total", "[", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"N", "[", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "An"}], ",", "An"}], "}"}], "]"}], "]"}], 
                    "}"}], ",", 
                   RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"T", ",", "0", ",", "t0"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], 
               ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}],
                ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"\"\<Frequency Spectrum\>\"", " ", 
                RowBox[{"(", 
                 RowBox[{"Real", " ", "Part"}], ")"}]}], ",", "\"\<Label\>\"",
                ",", "15", ",", "Red", ",", "Bold"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Sum", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Re", "[", 
                   RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "k", "*", "t"}], 
                    "+", "\[CurlyPhi]"}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", 
                    "A", "*", "m", "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", 
                    RowBox[{"(", 
                    RowBox[{"w", "-", "w0"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "/", 
                    "T2"}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                     "]"}]}], "]"}], "+", 
                  RowBox[{"An", "*", 
                   RowBox[{"Total", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Fourier", "[", 
                    RowBox[{"{", 
                    RowBox[{"N", "[", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "An"}], ",", "An"}], "}"}], "]"}], "]"}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}]}], 
                 "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "0", ",", 
                   RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"w", ",", 
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], 
                 "]"}]}], ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "All"}], 
                 "}"}]}], ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Free Induction Decay (Imaginary Part)\>\"", ",", 
               "\"\<Label\>\"", ",", "15", ",", "Red", ",", "Bold"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Im", "[", 
                 RowBox[{"m", "*", 
                  RowBox[{"Cos", "[", 
                   RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "t"}], "+", 
                    "\[CurlyPhi]"}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"T", "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", "lb"}], "*", "T"}], "]"}], "*", "A", "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", "w0", "*", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"T", "+", "Td"}], ")"}]}], "/", "T2"}], "]"}], 
                  "*", 
                  RowBox[{"Exp", "[", 
                   RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                    "]"}]}], "]"}], "+", 
                RowBox[{"Total", "[", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"N", "[", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "An"}], ",", "An"}], "}"}], "]"}], "]"}], 
                    "}"}], ",", 
                   RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"T", ",", "0", ",", "t0"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "t0"}], "}"}], ",", "All"}], "}"}]}], 
               ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<t (s)\>\"", ",", "16", ",", "Italic"}], "]"}]}],
                ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
              "\"\<Frequency Spectrum (Imaginary Part)\>\"", ",", 
               "\"\<Label\>\"", ",", "15", ",", "Red", ",", "Bold"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Plot", "[", 
              RowBox[{
               RowBox[{"Sum", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Im", "[", 
                   RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    RowBox[{"2", "*", "Pi", "*", "d", "*", "k", "*", "t"}], 
                    "+", "\[CurlyPhi]"}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", "*", "t"}], "-", "b"}], ")"}], "2"]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c"}], ")"}]}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}], "*", 
                    "A", "*", "m", "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"I", "*", "2", "*", "Pi", "*", 
                    RowBox[{"(", 
                    RowBox[{"w", "-", "w0"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "+", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{"\[Psi]", "/", "180"}]}]}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "*", "k"}], "+", "Td"}], ")"}]}], "/", 
                    "T2"}], "]"}], "*", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "Pi", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Psi]", "-", "\[Psi]c"}], ")"}], "/", "180"}]}],
                     "]"}]}], "]"}], "+", 
                  RowBox[{"An", "*", 
                   RowBox[{"Total", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Fourier", "[", 
                    RowBox[{"{", 
                    RowBox[{"N", "[", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "An"}], ",", "An"}], "}"}], "]"}], "]"}], 
                    "}"}], "]"}], ",", 
                    RowBox[{"{", "m", "}"}]}], "]"}], "]"}]}]}], 
                 "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"k", ",", "0", ",", 
                   RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"w", ",", 
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], ",", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<f (Hz)\>\"", ",", "16", ",", "Italic"}], 
                 "]"}]}], ",", 
               RowBox[{"PlotStyle", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"Red", ",", 
                  RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
               ",", 
               RowBox[{"PlotRange", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "All"}], 
                 "}"}]}], ",", 
               RowBox[{"ImageSize", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"400", ",", "200"}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "0.35"}]}], "]"}]}], "}"}], 
           ",", 
           RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<NMR Signal and Spectrum\>\"", ",", "15", ",", "Blue", ",", 
       "Bold"}], "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "Delimiter", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Parameters of Signal\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
      "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Td", ",", "0", ",", "\"\<Delay Time, Td/s\>\""}], "}"}], ",",
        "0", ",", "2.", ",", "0.001", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t0", ",", "2", ",", "\"\<Acquition time\>\""}], "}"}], ",", 
       "0.01", ",", "10", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", "20", ",", "\"\<Number of Data Points\>\""}], "}"}],
        ",", "10", ",", "100", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A", ",", "0.25", ",", "\"\<Amplitude\>\""}], "}"}], ",", 
       "0.01", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w0", ",", "1", ",", "\"\<Peak Position\>\""}], "}"}], ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Psi]", ",", "0", ",", "\"\<Initial Phase/\[Degree]\>\""}], 
        "}"}], ",", "0", ",", "360", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[Psi]c", ",", "0", ",", "\"\<Phase correction/\[Degree]\>\""}], 
        "}"}], ",", "0", ",", "360", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T2", ",", "2", ",", "\"\<T2 relaxation of nuclear\>\""}], 
        "}"}], ",", "0.1", ",", "5", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     "Delimiter", ",", "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Window Function\>\"", ",", "15", ",", "Blue", ",", "Bold"}], "]"}],
      ",", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lb", ",", "0", ",", "\"\<Exponential Apodization\>\""}], 
        "}"}], ",", "0", ",", "2", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "c", ",", "4", ",", "\"\<Gausiian Apodization (Variance)\>\""}], 
        "}"}], ",", "0.1", ",", "4", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "0", ",", "\"\<Gaussian Variance (Shift)\>\""}], 
        "}"}], ",", 
       RowBox[{"-", "10"}], ",", "10", ",", "0.1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d", ",", "0", ",", "\"\<Sine Function (Peoredical)\>\""}], 
        "}"}], ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\[CurlyPhi]", ",", "0", ",", "\"\<Sine Function (Shift)\>\""}], 
        "}"}], ",", "0", ",", "2", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Noise Control\>\"", ",", "15", ",", "Blue", ",", "Bold"}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"An", ",", "0.25", ",", "\"\<Amplitude of noise\>\""}], "}"}],
        ",", "0", ",", "1", ",", "0.01", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "1", ",", "\"\<Transients\>\""}], "}"}], ",", "1", 
       ",", "64", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", " ", "Small"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Left"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SaveDefinitions", "\[Rule]", " ", "True"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Exponential", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "lb"}], "*", "k", "*", "t"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Gaussian", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", "*", "t"}], "-", "b"}], 
          SuperscriptBox[")", "2"]}]}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Sin", " ", 
     RowBox[{"Function", ":", "\[IndentingNewLine]", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"d", "*", "k", "*", "t"}], "+", "\[CurlyPhi]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.538066545603765*^9, 3.538066665677204*^9}, {
   3.5380667223119097`*^9, 3.538066722928528*^9}, {3.538066851583358*^9, 
   3.5380668678923483`*^9}, {3.5380671498675413`*^9, 3.53806718354801*^9}, {
   3.538067322289507*^9, 3.5380673513668528`*^9}, {3.5380674017135277`*^9, 
   3.5380674391771173`*^9}, 3.5380674720840483`*^9, {3.538067537333908*^9, 
   3.538067739088065*^9}, {3.5380677808298397`*^9, 3.5380677915582047`*^9}, {
   3.538067826360496*^9, 3.538067833166543*^9}, {3.538067863211594*^9, 
   3.538067863538081*^9}, {3.538067913253138*^9, 3.5380679139750834`*^9}, {
   3.5380679685965157`*^9, 3.538067969009893*^9}, {3.538068010694824*^9, 
   3.538068033864871*^9}, {3.538068069589447*^9, 3.538068146489998*^9}, {
   3.538068275379229*^9, 3.538068275945369*^9}, {3.538068351892281*^9, 
   3.538068354020644*^9}, {3.538068447737094*^9, 3.5380684483756313`*^9}, {
   3.538068520374881*^9, 3.538068536576665*^9}, {3.5380686479009237`*^9, 
   3.53806872069777*^9}, {3.538068775742433*^9, 3.538068822792531*^9}, {
   3.538068860078762*^9, 3.538068898069695*^9}, {3.5380689512033052`*^9, 
   3.538069117904212*^9}, {3.538069186694701*^9, 3.5380692555392933`*^9}, {
   3.5380692873904867`*^9, 3.538069297533926*^9}, {3.5380693327249002`*^9, 
   3.5380694716546793`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`A$$ = 0.25, $CellContext`An$$ = 
    0.25, $CellContext`b$$ = 0, $CellContext`c$$ = 4, $CellContext`d$$ = 
    0, $CellContext`lb$$ = 0, $CellContext`m$$ = 1, $CellContext`n$$ = 
    20, $CellContext`t0$$ = 2, $CellContext`T2$$ = 2, $CellContext`Td$$ = 
    0, $CellContext`w0$$ = 1, $CellContext`\[CurlyPhi]$$ = 
    0, $CellContext`\[Psi]$$ = 0, $CellContext`\[Psi]c$$ = 0, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["NMR Signal and Spectrum", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["Parameters of Signal", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Td$$], 0, "Delay Time, Td/s"}, 0, 2., 0.001}, {{
       Hold[$CellContext`t0$$], 2, "Acquition time"}, 0.01, 10, 0.01}, {{
       Hold[$CellContext`n$$], 20, "Number of Data Points"}, 10, 100, 1}, {{
       Hold[$CellContext`A$$], 0.25, "Amplitude"}, 0.01, 1, 0.01}, {{
       Hold[$CellContext`w0$$], 1, "Peak Position"}, -5, 5, 0.1}, {{
       Hold[$CellContext`\[Psi]$$], 0, "Initial Phase/\[Degree]"}, 0, 360, 
      0.1}, {{
       Hold[$CellContext`\[Psi]c$$], 0, "Phase correction/\[Degree]"}, 0, 360,
       0.1}, {{
       Hold[$CellContext`T2$$], 2, "T2 relaxation of nuclear"}, 0.1, 5, 
      0.01}, {
      Hold[
       Style["Window Function", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`lb$$], 0, "Exponential Apodization"}, 0, 2, 0.01}, {{
      
       Hold[$CellContext`c$$], 4, "Gausiian Apodization (Variance)"}, 0.1, 4, 
      0.01}, {{
       Hold[$CellContext`b$$], 0, "Gaussian Variance (Shift)"}, -10, 10, 
      0.1}, {{
       Hold[$CellContext`d$$], 0, "Sine Function (Peoredical)"}, 0, 1, 
      0.01}, {{
       Hold[$CellContext`\[CurlyPhi]$$], 0, "Sine Function (Shift)"}, 0, 2, 
      0.01}, {
      Hold[
       Style["Noise Control", 15, 
        RGBColor[0, 0, 1], Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`An$$], 0.25, "Amplitude of noise"}, 0, 1, 0.01}, {{
       Hold[$CellContext`m$$], 1, "Transients"}, 1, 64, 1}}, 
    Typeset`size$$ = {803., {219.84375, 225.15625}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`Td$14494$$ = 0, $CellContext`t0$14495$$ = 
    0, $CellContext`n$14496$$ = 0, $CellContext`A$14497$$ = 
    0, $CellContext`w0$14498$$ = 0, $CellContext`\[Psi]$14499$$ = 
    0, $CellContext`\[Psi]c$14500$$ = 0, $CellContext`T2$14501$$ = 
    0, $CellContext`lb$14502$$ = 0, $CellContext`c$14503$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`A$$ = 0.25, $CellContext`An$$ = 
        0.25, $CellContext`b$$ = 0, $CellContext`c$$ = 4, $CellContext`d$$ = 
        0, $CellContext`lb$$ = 0, $CellContext`m$$ = 1, $CellContext`n$$ = 
        20, $CellContext`t0$$ = 2, $CellContext`T2$$ = 2, $CellContext`Td$$ = 
        0, $CellContext`w0$$ = 1, $CellContext`\[CurlyPhi]$$ = 
        0, $CellContext`\[Psi]$$ = 0, $CellContext`\[Psi]c$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`Td$$, $CellContext`Td$14494$$, 0], 
        Hold[$CellContext`t0$$, $CellContext`t0$14495$$, 0], 
        Hold[$CellContext`n$$, $CellContext`n$14496$$, 0], 
        Hold[$CellContext`A$$, $CellContext`A$14497$$, 0], 
        Hold[$CellContext`w0$$, $CellContext`w0$14498$$, 0], 
        Hold[$CellContext`\[Psi]$$, $CellContext`\[Psi]$14499$$, 0], 
        Hold[$CellContext`\[Psi]c$$, $CellContext`\[Psi]c$14500$$, 0], 
        Hold[$CellContext`T2$$, $CellContext`T2$14501$$, 0], 
        Hold[$CellContext`lb$$, $CellContext`lb$14502$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$14503$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`t = $CellContext`t0$$/$CellContext`n$$; Row[{
          Column[{
            Style["Free Induction Decay (Real Part)", "Label", 15, Red, Bold], 
            Plot[
            Re[$CellContext`m$$ 
               Cos[2 Pi $CellContext`d$$ $CellContext`t + $CellContext`\
\[CurlyPhi]$$] 
               Exp[(-($CellContext`T - $CellContext`b$$)^2)/(
                 2 $CellContext`c$$)] 
               Exp[(-$CellContext`lb$$) $CellContext`T] $CellContext`A$$ 
               Exp[I 2 
                  Pi $CellContext`w0$$ ($CellContext`T + $CellContext`Td$$) + 
                 I Pi ($CellContext`\[Psi]$$/180)] 
               Exp[(-($CellContext`T + $CellContext`Td$$))/$CellContext`T2$$] 
               Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                  180)]] + Total[
               Table[{
                 N[
                  
                  RandomReal[{-$CellContext`An$$, $CellContext`An$$}]]}, \
{$CellContext`m$$}]], {$CellContext`T, 0, $CellContext`t0$$}, 
             PlotRange -> {{0, $CellContext`t0$$}, All}, Frame -> True, 
             FrameLabel -> Style["t (s)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
             0.35], 
            Style["Frequency Spectrum" (Real Part), "Label", 15, Red, Bold], 
            Plot[
             Sum[
             Re[Cos[2 
                   Pi $CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
                Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
                  2 $CellContext`c$$)] 
                Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A$$ $CellContext`m$$ 
                Exp[I 2 
                   Pi ($CellContext`w - $CellContext`w0$$) ($CellContext`t \
$CellContext`k + $CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
                Exp[(-($CellContext`t $CellContext`k + \
$CellContext`Td$$))/$CellContext`T2$$] 
                Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                   180)]] + $CellContext`An$$ Total[
                 Table[
                  Fourier[{
                    N[
                    
                    RandomReal[{-$CellContext`An$$, $CellContext`An$$}]]}], \
{$CellContext`m$$}]], {$CellContext`k, 0, $CellContext`n$$ - 
               1}], {$CellContext`w, -5, 5}, Frame -> True, FrameLabel -> 
             Style["f (Hz)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, PlotRange -> {{-5, 5}, All}, 
             ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> 
           Center], 
          Column[{
            Style[
            "Free Induction Decay (Imaginary Part)", "Label", 15, Red, Bold], 
            
            Plot[
            Im[$CellContext`m$$ 
               Cos[2 Pi $CellContext`d$$ $CellContext`t + $CellContext`\
\[CurlyPhi]$$] 
               Exp[(-($CellContext`T - $CellContext`b$$)^2)/(
                 2 $CellContext`c$$)] 
               Exp[(-$CellContext`lb$$) $CellContext`T] $CellContext`A$$ 
               Exp[I 2 
                  Pi $CellContext`w0$$ ($CellContext`T + $CellContext`Td$$) + 
                 I Pi ($CellContext`\[Psi]$$/180)] 
               Exp[(-($CellContext`T + $CellContext`Td$$))/$CellContext`T2$$] 
               Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                  180)]] + Total[
               Table[{
                 N[
                  
                  RandomReal[{-$CellContext`An$$, $CellContext`An$$}]]}, \
{$CellContext`m$$}]], {$CellContext`T, 0, $CellContext`t0$$}, 
             PlotRange -> {{0, $CellContext`t0$$}, All}, Frame -> True, 
             FrameLabel -> Style["t (s)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, ImageSize -> {400, 200}, AspectRatio -> 
             0.35], 
            Style[
            "Frequency Spectrum (Imaginary Part)", "Label", 15, Red, Bold], 
            Plot[
             Sum[
             Im[Cos[2 
                   Pi $CellContext`d$$ $CellContext`k $CellContext`t + \
$CellContext`\[CurlyPhi]$$] 
                Exp[(-($CellContext`k $CellContext`t - $CellContext`b$$)^2)/(
                  2 $CellContext`c$$)] 
                Exp[(-$CellContext`lb$$) $CellContext`k $CellContext`t] \
$CellContext`A$$ $CellContext`m$$ 
                Exp[I 2 
                   Pi ($CellContext`w - $CellContext`w0$$) ($CellContext`t \
$CellContext`k + $CellContext`Td$$) + I Pi ($CellContext`\[Psi]$$/180)] 
                Exp[(-($CellContext`t $CellContext`k + \
$CellContext`Td$$))/$CellContext`T2$$] 
                Exp[I Pi (($CellContext`\[Psi]$$ - $CellContext`\[Psi]c$$)/
                   180)]] + $CellContext`An$$ Total[
                 Table[
                  Fourier[{
                    N[
                    
                    RandomReal[{-$CellContext`An$$, $CellContext`An$$}]]}], \
{$CellContext`m$$}]], {$CellContext`k, 0, $CellContext`n$$ - 
               1}], {$CellContext`w, -5, 5}, Frame -> True, FrameLabel -> 
             Style["f (Hz)", 16, Italic], PlotStyle -> {Red, 
               AbsoluteThickness[2]}, PlotRange -> {{-5, 5}, All}, 
             ImageSize -> {400, 200}, AspectRatio -> 0.35]}, Alignment -> 
           Center]}]), "Specifications" :> {
        Style["NMR Signal and Spectrum", 15, 
         RGBColor[0, 0, 1], Bold], Delimiter, 
        Style["Parameters of Signal", 15, 
         RGBColor[0, 0, 1], 
         Bold], {{$CellContext`Td$$, 0, "Delay Time, Td/s"}, 0, 2., 0.001, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`t0$$, 2, "Acquition time"}, 0.01, 10, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`n$$, 20, "Number of Data Points"}, 10, 100, 1,
          Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`A$$, 0.25, "Amplitude"}, 0.01, 1, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`w0$$, 1, "Peak Position"}, -5, 5, 0.1, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[Psi]$$, 0, "Initial Phase/\[Degree]"}, 0, 
         360, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[Psi]c$$, 0, "Phase correction/\[Degree]"}, 
         0, 360, 0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`T2$$, 2, "T2 relaxation of nuclear"}, 0.1, 5, 
         0.01, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Window Function", 15, 
         RGBColor[0, 0, 1], Bold], 
        Delimiter, {{$CellContext`lb$$, 0, "Exponential Apodization"}, 0, 2, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`c$$, 4, "Gausiian Apodization (Variance)"}, 
         0.1, 4, 0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`b$$, 0, "Gaussian Variance (Shift)"}, -10, 10,
          0.1, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`d$$, 0, "Sine Function (Peoredical)"}, 0, 1, 
         0.01, Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`\[CurlyPhi]$$, 0, "Sine Function (Shift)"}, 0,
          2, 0.01, Appearance -> "Labeled", ImageSize -> Small}, Delimiter, 
        Style["Noise Control", 15, 
         RGBColor[0, 0, 1], 
         Bold], {{$CellContext`An$$, 0.25, "Amplitude of noise"}, 0, 1, 0.01, 
         Appearance -> "Labeled", ImageSize -> 
         Small}, {{$CellContext`m$$, 1, "Transients"}, 1, 64, 1, Appearance -> 
         "Labeled", ImageSize -> Small}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{1143., {247., 252.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`t = 1/10}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.538067475031095*^9, 3.538067744260808*^9, 3.538067797090138*^9, {
   3.538067839326479*^9, 3.5380678657407084`*^9}, 3.538067920315099*^9, 
   3.538067974811541*^9, {3.5380680240704203`*^9, 3.538068038236834*^9}, 
   3.538068158736781*^9, 3.538068278609116*^9, 3.538068450698997*^9, 
   3.53806853861519*^9, 3.53806869821134*^9, {3.538068806436576*^9, 
   3.538068825249309*^9}, 3.538068914434081*^9, 3.538069021387354*^9, 
   3.538069082493169*^9, 3.5380691194737673`*^9, {3.538069215032196*^9, 
   3.538069256896874*^9}, {3.538069289590259*^9, 3.538069298924855*^9}, {
   3.5380693680512953`*^9, 3.5380694274461317`*^9}, 3.5380694737334948`*^9}]
}, Open  ]]
},
WindowSize->{1280, 681},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 26033, 585, 1321, "Input"],
Cell[26615, 609, 13104, 245, 516, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
